#!/usr/bin/env ruby
# coding: utf-8

# TODO: tilføj understøttelse for Linux
#       + PPD baseret på platform

DIALOG="dialog --stdout --title 'Printeropsætning'"

class Printer
  def initialize(tag, name, smb, location, ppd="/System/Library/Frameworks/ApplicationServices.framework/Frameworks/PrintCore.framework/Resources/Generic.ppd")
    @tag = tag
    @name = name
    @smb = smb
    @location = location
    @ppd = ppd
  end
  
  attr_accessor :tag, :name, :smb, :location, :ppd
end

# Add color support for String objects
class String
  def colorise ansi_code
    "\e[#{ansi_code}m#{self}\e[0m"
  end

  def red
    colorise 31
  end

  def green
    colorise 32
  end

  def yellow
    colorise 33
  end

  def blue
    colorise 34
  end
end


# Define methods

def is_installed? printer  
  `lpstat -E -v`.include? printer.name
end

def install_printer printer
  puts "[#{printer.tag.blue}]"

  puts "- Undersøger om printer allerede er registreret i CUPS..."
  if is_installed? printer then
    return :EXISTS
  end

  puts "- Registerer printer i CUPS..."
  `lpadmin -p '#{printer.name}' -E -P '#{printer.ppd}' -v '#{printer.smb}'`

  if $? == 0 then
    :SUCCESS
  else
    :FAIL
  end
end

def smb_prefix s
  "smb://print.uni.au.dk/" + s
end


# Define printers
load 'printers.rb'

# --------------------------------

# Check dependency for dialog
`which dialog`
unless $? == 0 then
  puts "'dialog' needs to be installed and be in your PATH"
  exit 1
end

# Ask for printers to be installed
dialog_command = "#{DIALOG} --checklist 'Vælg de printere som De ønsker at installere på Deres datamat.' #{10 + PRINTERS.length} 50 18 "

dialog_command << PRINTERS.map { |obj| "#{obj.tag} '#{obj.location}' 0" }.join(" ")

res = `#{dialog_command}`

to_be_installed = res.split(" ").map { |s| PRINTERS_HASH[s] }

if to_be_installed.empty? then
  system "clear"
  puts "No printers selected!\n\nExiting…"
  exit 0
end

# Confirm printers to be installed
confirmation_list = to_be_installed.map { |obj| "* #{obj.tag}" }.join(" \n")
dialog_command = "#{DIALOG} --yesno 'Er De sikker på at De ønsker at opsætte følgende printere?\n\n#{confirmation_list}' #{8 + to_be_installed.length} 40"


`#{dialog_command}`
res = $?
system "clear"

if res == 0 then
  puts "Opsætter printer(e): #{ to_be_installed.map(&:tag).map(&:blue).join(", ") }"
  print "\n"
else
  puts "Opsætning anulleret"
  exit 0
end


# Install printers
to_be_installed.each do |printer|
  case install_printer printer
  when :SUCCESS
    puts "Opsætning af '#{printer.tag}' blev gennemført succesfuldt!".green
    print "\n"
  when :FAIL
    puts "Opsætning af '#{printer.tag}' fejlede!".red
    print "\n"
  when :EXISTS
    puts "Printer '#{printer.tag}' er allerede opsat på Deres datamat.".yellow
    print "\n"
  end
end
