# Author: Christoffer Müller Madsen <christoffer@guava.space>
# Created: sometime in 2016 or 2016
# Updated: 2025-10-04 Seasons/tags added

require 'date'
require 'fileutils'

IGNORE_RECENT_N=3

wall_path = "/home/christoffer/Photos/Wallpapers/"
log_path = "/home/christoffer/.log/wal"

tags = []

## Seasons

cur_month = Date.today.month
seasons = { # Note that a date might match multiple seasons
  [11, 12] => :winter,
  [1, 3] => :winter,
  [2, 6] => :spring,
  [5, 9] => :summer,
  [9, 12] => :autumn,
  [10, 10] => :halloween,
  [12, 12] => :christmas,
}
cur_seasons = seasons.select do |k, v|
  k[0] <= cur_month and cur_month <= k[1]
end.map do |k, v|
  v
end.uniq

if cur_seasons
  tags.push(*cur_seasons)
end

## Read files based on tags

files_uncategorized = Dir[wall_path + "*.jpg"]
files_tagged = tags.flat_map do |t|
  Dir[File.join(wall_path, t.to_s) + "/*.jpg"]
end
files = files_uncategorized + files_tagged + files_tagged  # Prioritize tagged images

filenames = files.map { |f| [f, f.split("/")[-1]] }.to_h

FileUtils.touch log_path
File.open log_path, "r" do |log|
  recent = log.read.split("\n")[-1*(IGNORE_RECENT_N or 1)..-1]
  unless recent == nil
    files.delete_if {|f| recent.include? filenames[f]}
  end
end

choice = files.sample

`/usr/bin/wal -i #{choice}`

File.open log_path, 'a+' do |log|
  log << filenames[choice] + "\n"
end

puts choice
